package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceStateUpdateExclusionRules(
    amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules = {
    import ResourceStateUpdateExclusionRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules
      .builder()
      .optionallyWith(amis.map(value => value.buildAwsValue()))(_.amis)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly =
    zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules
      .wrap(buildAwsValue())
}
object ResourceStateUpdateExclusionRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules =
      zio.aws.imagebuilder.model
        .ResourceStateUpdateExclusionRules(amis.map(value => value.asEditable))
    def amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ]
    def getAmis: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ] = AwsError.unwrapOptionField("amis", amis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules
  ) extends zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly {
    override val amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amis())
      .map(value =>
        zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceStateUpdateExclusionRules
  ): zio.aws.imagebuilder.model.ResourceStateUpdateExclusionRules.ReadOnly =
    new Wrapper(impl)
}
