package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceState(
    status: Optional[zio.aws.imagebuilder.model.ResourceStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ResourceState = {
    import ResourceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ResourceState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ResourceState.ReadOnly =
    zio.aws.imagebuilder.model.ResourceState.wrap(buildAwsValue())
}
object ResourceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ResourceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ResourceState =
      zio.aws.imagebuilder.model.ResourceState(status.map(value => value))
    def status: Optional[zio.aws.imagebuilder.model.ResourceStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ResourceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceState
  ) extends zio.aws.imagebuilder.model.ResourceState.ReadOnly {
    override val status: Optional[zio.aws.imagebuilder.model.ResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.ResourceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ResourceState
  ): zio.aws.imagebuilder.model.ResourceState.ReadOnly = new Wrapper(impl)
}
