package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  ImageRecipeArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutImageRecipePolicyRequest(
    imageRecipeArn: ImageRecipeArn,
    policy: ResourcePolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest = {
    import PutImageRecipePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest
      .builder()
      .imageRecipeArn(ImageRecipeArn.unwrap(imageRecipeArn): java.lang.String)
      .policy(ResourcePolicyDocument.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutImageRecipePolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.PutImageRecipePolicyRequest.wrap(buildAwsValue())
}
object PutImageRecipePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutImageRecipePolicyRequest =
      zio.aws.imagebuilder.model
        .PutImageRecipePolicyRequest(imageRecipeArn, policy)
    def imageRecipeArn: ImageRecipeArn
    def policy: ResourcePolicyDocument
    def getImageRecipeArn: ZIO[Any, Nothing, ImageRecipeArn] =
      ZIO.succeed(imageRecipeArn)
    def getPolicy: ZIO[Any, Nothing, ResourcePolicyDocument] =
      ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest
  ) extends zio.aws.imagebuilder.model.PutImageRecipePolicyRequest.ReadOnly {
    override val imageRecipeArn: ImageRecipeArn =
      zio.aws.imagebuilder.model.primitives
        .ImageRecipeArn(impl.imageRecipeArn())
    override val policy: ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives
        .ResourcePolicyDocument(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest
  ): zio.aws.imagebuilder.model.PutImageRecipePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
