package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  ContainerRecipeArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutContainerRecipePolicyRequest(
    containerRecipeArn: ContainerRecipeArn,
    policy: ResourcePolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest = {
    import PutContainerRecipePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest
      .builder()
      .containerRecipeArn(
        ContainerRecipeArn.unwrap(containerRecipeArn): java.lang.String
      )
      .policy(ResourcePolicyDocument.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutContainerRecipePolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.PutContainerRecipePolicyRequest
      .wrap(buildAwsValue())
}
object PutContainerRecipePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutContainerRecipePolicyRequest =
      zio.aws.imagebuilder.model
        .PutContainerRecipePolicyRequest(containerRecipeArn, policy)
    def containerRecipeArn: ContainerRecipeArn
    def policy: ResourcePolicyDocument
    def getContainerRecipeArn: ZIO[Any, Nothing, ContainerRecipeArn] =
      ZIO.succeed(containerRecipeArn)
    def getPolicy: ZIO[Any, Nothing, ResourcePolicyDocument] =
      ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest
  ) extends zio.aws.imagebuilder.model.PutContainerRecipePolicyRequest.ReadOnly {
    override val containerRecipeArn: ContainerRecipeArn =
      zio.aws.imagebuilder.model.primitives
        .ContainerRecipeArn(impl.containerRecipeArn())
    override val policy: ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives
        .ResourcePolicyDocument(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest
  ): zio.aws.imagebuilder.model.PutContainerRecipePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
