package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  ComponentBuildVersionArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutComponentPolicyRequest(
    componentArn: ComponentBuildVersionArn,
    policy: ResourcePolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest = {
    import PutComponentPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest
      .builder()
      .componentArn(
        ComponentBuildVersionArn.unwrap(componentArn): java.lang.String
      )
      .policy(ResourcePolicyDocument.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutComponentPolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.PutComponentPolicyRequest.wrap(buildAwsValue())
}
object PutComponentPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutComponentPolicyRequest =
      zio.aws.imagebuilder.model.PutComponentPolicyRequest(componentArn, policy)
    def componentArn: ComponentBuildVersionArn
    def policy: ResourcePolicyDocument
    def getComponentArn: ZIO[Any, Nothing, ComponentBuildVersionArn] =
      ZIO.succeed(componentArn)
    def getPolicy: ZIO[Any, Nothing, ResourcePolicyDocument] =
      ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest
  ) extends zio.aws.imagebuilder.model.PutComponentPolicyRequest.ReadOnly {
    override val componentArn: ComponentBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentBuildVersionArn(impl.componentArn())
    override val policy: ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives
        .ResourcePolicyDocument(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest
  ): zio.aws.imagebuilder.model.PutComponentPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
