package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ProductCodeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ProductCodeListItem(
    productCodeId: ProductCodeId,
    productCodeType: zio.aws.imagebuilder.model.ProductCodeType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ProductCodeListItem = {
    import ProductCodeListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ProductCodeListItem
      .builder()
      .productCodeId(ProductCodeId.unwrap(productCodeId): java.lang.String)
      .productCodeType(productCodeType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly =
    zio.aws.imagebuilder.model.ProductCodeListItem.wrap(buildAwsValue())
}
object ProductCodeListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ProductCodeListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ProductCodeListItem =
      zio.aws.imagebuilder.model
        .ProductCodeListItem(productCodeId, productCodeType)
    def productCodeId: ProductCodeId
    def productCodeType: zio.aws.imagebuilder.model.ProductCodeType
    def getProductCodeId: ZIO[Any, Nothing, ProductCodeId] =
      ZIO.succeed(productCodeId)
    def getProductCodeType
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.ProductCodeType] =
      ZIO.succeed(productCodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ProductCodeListItem
  ) extends zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly {
    override val productCodeId: ProductCodeId =
      zio.aws.imagebuilder.model.primitives.ProductCodeId(impl.productCodeId())
    override val productCodeType: zio.aws.imagebuilder.model.ProductCodeType =
      zio.aws.imagebuilder.model.ProductCodeType.wrap(impl.productCodeType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ProductCodeListItem
  ): zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly = new Wrapper(impl)
}
