package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait Platform {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.Platform
}
object Platform {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.Platform
  ): zio.aws.imagebuilder.model.Platform = value match {
    case software.amazon.awssdk.services.imagebuilder.model.Platform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.Platform.WINDOWS =>
      val r = Windows
      r
    case software.amazon.awssdk.services.imagebuilder.model.Platform.LINUX =>
      val r = Linux
      r
    case software.amazon.awssdk.services.imagebuilder.model.Platform.MAC_OS =>
      val r = macOS
      r
  }
  case object unknownToSdkVersion extends zio.aws.imagebuilder.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Platform =
      software.amazon.awssdk.services.imagebuilder.model.Platform.UNKNOWN_TO_SDK_VERSION
  }
  case object Windows extends zio.aws.imagebuilder.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Platform =
      software.amazon.awssdk.services.imagebuilder.model.Platform.WINDOWS
  }
  case object Linux extends zio.aws.imagebuilder.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Platform =
      software.amazon.awssdk.services.imagebuilder.model.Platform.LINUX
  }
  case object macOS extends zio.aws.imagebuilder.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Platform =
      software.amazon.awssdk.services.imagebuilder.model.Platform.MAC_OS
  }
}
