package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowsResponse(
    workflowVersionList: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowVersion]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse = {
    import ListWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse
      .builder()
      .optionallyWith(
        workflowVersionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowVersionList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowsResponse.wrap(buildAwsValue())
}
object ListWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListWorkflowsResponse =
      zio.aws.imagebuilder.model.ListWorkflowsResponse(
        workflowVersionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def workflowVersionList
        : Optional[List[zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getWorkflowVersionList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowVersionList", workflowVersionList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse
  ) extends zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly {
    override val workflowVersionList
        : Optional[List[zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowVersionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.WorkflowVersion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowsResponse
  ): zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly = new Wrapper(
    impl
  )
}
