package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  ImageBuildMessage,
  ImageBuildVersionArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowExecutionsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    workflowExecutions: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowExecutionMetadata]
    ] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    message: Optional[ImageBuildMessage] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse = {
    import ListWorkflowExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        workflowExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowExecutions)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        message.map(value => ImageBuildMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse =
      zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse(
        requestId.map(value => value),
        workflowExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageBuildVersionArn.map(value => value),
        message.map(value => value),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def workflowExecutions: Optional[
      List[zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly]
    ]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def message: Optional[ImageBuildMessage]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getWorkflowExecutions: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowExecutions", workflowExecutions)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getMessage: ZIO[Any, AwsError, ImageBuildMessage] =
      AwsError.unwrapOptionField("message", message)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse
  ) extends zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val workflowExecutions: Optional[
      List[zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowExecutionMetadata.wrap(item)
        }.toList
      )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val message: Optional[ImageBuildMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuildMessage(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsResponse
  ): zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
