package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  WorkflowWildcardVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkflowBuildVersionsRequest(
    workflowVersionArn: WorkflowWildcardVersionArn,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest = {
    import ListWorkflowBuildVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest
      .builder()
      .workflowVersionArn(
        WorkflowWildcardVersionArn.unwrap(workflowVersionArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowBuildVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest =
      zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest(
        workflowVersionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workflowVersionArn: WorkflowWildcardVersionArn
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getWorkflowVersionArn: ZIO[Any, Nothing, WorkflowWildcardVersionArn] =
      ZIO.succeed(workflowVersionArn)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest
  ) extends zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest.ReadOnly {
    override val workflowVersionArn: WorkflowWildcardVersionArn =
      zio.aws.imagebuilder.model.primitives
        .WorkflowWildcardVersionArn(impl.workflowVersionArn())
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowBuildVersionsRequest
  ): zio.aws.imagebuilder.model.ListWorkflowBuildVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
