package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWaitingWorkflowStepsResponse(
    steps: Optional[
      Iterable[zio.aws.imagebuilder.model.WorkflowStepExecution]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse = {
    import ListWaitingWorkflowStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse
      .wrap(buildAwsValue())
}
object ListWaitingWorkflowStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse =
      zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def steps: Optional[
      List[zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse
  ) extends zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly {
    override val steps: Optional[
      List[zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowStepExecution.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse
  ): zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly =
    new Wrapper(impl)
}
