package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLifecycleExecutionsResponse(
    lifecycleExecutions: Optional[
      Iterable[zio.aws.imagebuilder.model.LifecycleExecution]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse = {
    import ListLifecycleExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse
      .builder()
      .optionallyWith(
        lifecycleExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecycleExecutions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse
      .wrap(buildAwsValue())
}
object ListLifecycleExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse =
      zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse(
        lifecycleExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lifecycleExecutions
        : Optional[List[zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getLifecycleExecutions: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
    ]] = AwsError.unwrapOptionField("lifecycleExecutions", lifecycleExecutions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse
  ) extends zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly {
    override val lifecycleExecutions: Optional[
      List[zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleExecutions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecycleExecution.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsResponse
  ): zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
