package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  PaginationToken,
  RestrictedInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLifecycleExecutionsRequest(
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    resourceArn: ImageBuilderArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest = {
    import ListLifecycleExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceArn(ImageBuilderArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest
      .wrap(buildAwsValue())
}
object ListLifecycleExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest =
      zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def resourceArn: ImageBuilderArn
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, ImageBuilderArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest
  ) extends zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest.ReadOnly {
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
    override val resourceArn: ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionsRequest
  ): zio.aws.imagebuilder.model.ListLifecycleExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
