package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  LifecycleExecutionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLifecycleExecutionResourcesResponse(
    lifecycleExecutionId: Optional[LifecycleExecutionId] = Optional.Absent,
    lifecycleExecutionState: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionState
    ] = Optional.Absent,
    resources: Optional[
      Iterable[zio.aws.imagebuilder.model.LifecycleExecutionResource]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse = {
    import ListLifecycleExecutionResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
      .builder()
      .optionallyWith(
        lifecycleExecutionId.map(value =>
          LifecycleExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleExecutionId)
      .optionallyWith(
        lifecycleExecutionState.map(value => value.buildAwsValue())
      )(_.lifecycleExecutionState)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse
      .wrap(buildAwsValue())
}
object ListLifecycleExecutionResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse =
      zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse(
        lifecycleExecutionId.map(value => value),
        lifecycleExecutionState.map(value => value.asEditable),
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def lifecycleExecutionId: Optional[LifecycleExecutionId]
    def lifecycleExecutionState
        : Optional[zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly]
    def resources: Optional[
      List[zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getLifecycleExecutionId: ZIO[Any, AwsError, LifecycleExecutionId] =
      AwsError.unwrapOptionField("lifecycleExecutionId", lifecycleExecutionId)
    def getLifecycleExecutionState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleExecutionState",
      lifecycleExecutionState
    )
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
  ) extends zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly {
    override val lifecycleExecutionId: Optional[LifecycleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecycleExecutionId(value)
        )
    override val lifecycleExecutionState: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleExecutionState())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionState.wrap(value)
      )
    override val resources: Optional[
      List[zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecycleExecutionResource.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesResponse
  ): zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
