package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  NonEmptyString,
  LifecycleExecutionId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLifecycleExecutionResourcesRequest(
    lifecycleExecutionId: LifecycleExecutionId,
    parentResourceId: Optional[NonEmptyString] = Optional.Absent,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest = {
    import ListLifecycleExecutionResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
      .builder()
      .lifecycleExecutionId(
        LifecycleExecutionId.unwrap(lifecycleExecutionId): java.lang.String
      )
      .optionallyWith(
        parentResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parentResourceId)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest
      .wrap(buildAwsValue())
}
object ListLifecycleExecutionResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest =
      zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest(
        lifecycleExecutionId,
        parentResourceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def lifecycleExecutionId: LifecycleExecutionId
    def parentResourceId: Optional[NonEmptyString]
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getLifecycleExecutionId: ZIO[Any, Nothing, LifecycleExecutionId] =
      ZIO.succeed(lifecycleExecutionId)
    def getParentResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentResourceId", parentResourceId)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
  ) extends zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest.ReadOnly {
    override val lifecycleExecutionId: LifecycleExecutionId =
      zio.aws.imagebuilder.model.primitives
        .LifecycleExecutionId(impl.lifecycleExecutionId())
    override val parentResourceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentResourceId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListLifecycleExecutionResourcesRequest
  ): zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
