package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListImageScanFindingAggregationsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    aggregationType: Optional[NonEmptyString] = Optional.Absent,
    responses: Optional[
      Iterable[zio.aws.imagebuilder.model.ImageScanFindingAggregation]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse = {
    import ListImageScanFindingAggregationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        aggregationType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.aggregationType)
      .optionallyWith(
        responses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responses)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse
      .wrap(buildAwsValue())
}
object ListImageScanFindingAggregationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse =
      zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse(
        requestId.map(value => value),
        aggregationType.map(value => value),
        responses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def aggregationType: Optional[NonEmptyString]
    def responses: Optional[
      List[zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getAggregationType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("aggregationType", aggregationType)
    def getResponses: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
    ]] = AwsError.unwrapOptionField("responses", responses)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
  ) extends zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val aggregationType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregationType())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val responses: Optional[
      List[zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ImageScanFindingAggregation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse
  ): zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly =
    new Wrapper(impl)
}
