package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDistributionConfigurationsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    distributionConfigurationSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.DistributionConfigurationSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse = {
    import ListDistributionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfigurationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributionConfigurationSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListDistributionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse =
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse(
        requestId.map(value => value),
        distributionConfigurationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def distributionConfigurationSummaryList: Optional[
      List[zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfigurationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "distributionConfigurationSummaryList",
      distributionConfigurationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ) extends zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfigurationSummaryList: Optional[
      List[zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfigurationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.DistributionConfigurationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ): zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
