package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ComponentVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListComponentBuildVersionsRequest(
    componentVersionArn: ComponentVersionArn,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest = {
    import ListComponentBuildVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
      .builder()
      .componentVersionArn(
        ComponentVersionArn.unwrap(componentVersionArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest
      .wrap(buildAwsValue())
}
object ListComponentBuildVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest =
      zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest(
        componentVersionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def componentVersionArn: ComponentVersionArn
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getComponentVersionArn: ZIO[Any, Nothing, ComponentVersionArn] =
      ZIO.succeed(componentVersionArn)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ) extends zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly {
    override val componentVersionArn: ComponentVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentVersionArn(impl.componentVersionArn())
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ): zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
