package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicyDetailExclusionRules(
    tagMap: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRules = {
    import LifecyclePolicyDetailExclusionRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRules
      .builder()
      .optionallyWith(
        tagMap.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tagMap)
      .optionallyWith(amis.map(value => value.buildAwsValue()))(_.amis)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules
      .wrap(buildAwsValue())
}
object LifecyclePolicyDetailExclusionRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules =
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules(
        tagMap.map(value => value),
        amis.map(value => value.asEditable)
      )
    def tagMap: Optional[Map[TagKey, TagValue]]
    def amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ]
    def getTagMap: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tagMap", tagMap)
    def getAmis: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ] = AwsError.unwrapOptionField("amis", amis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRules
  ) extends zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly {
    override val tagMap: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val amis: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amis())
      .map(value =>
        zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRulesAmis
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicyDetailExclusionRules
  ): zio.aws.imagebuilder.model.LifecyclePolicyDetailExclusionRules.ReadOnly =
    new Wrapper(impl)
}
