package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  RoleNameOrArn,
  LifecyclePolicyArn,
  TagValue,
  DateTimeTimestamp,
  NonEmptyString,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicy(
    arn: Optional[LifecyclePolicyArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      Optional.Absent,
    executionRole: Optional[RoleNameOrArn] = Optional.Absent,
    resourceType: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceType
    ] = Optional.Absent,
    policyDetails: Optional[
      Iterable[zio.aws.imagebuilder.model.LifecyclePolicyDetail]
    ] = Optional.Absent,
    resourceSelection: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection
    ] = Optional.Absent,
    dateCreated: Optional[DateTimeTimestamp] = Optional.Absent,
    dateUpdated: Optional[DateTimeTimestamp] = Optional.Absent,
    dateLastRun: Optional[DateTimeTimestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicy = {
    import LifecyclePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicy
      .builder()
      .optionallyWith(
        arn.map(value => LifecyclePolicyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        executionRole.map(value =>
          RoleNameOrArn.unwrap(value): java.lang.String
        )
      )(_.executionRole)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        policyDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyDetails)
      .optionallyWith(resourceSelection.map(value => value.buildAwsValue()))(
        _.resourceSelection
      )
      .optionallyWith(
        dateCreated.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.dateUpdated)
      .optionallyWith(
        dateLastRun.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.dateLastRun)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly =
    zio.aws.imagebuilder.model.LifecyclePolicy.wrap(buildAwsValue())
}
object LifecyclePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecyclePolicy =
      zio.aws.imagebuilder.model.LifecyclePolicy(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        executionRole.map(value => value),
        resourceType.map(value => value),
        policyDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceSelection.map(value => value.asEditable),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        dateLastRun.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[LifecyclePolicyArn]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def status: Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus]
    def executionRole: Optional[RoleNameOrArn]
    def resourceType
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicyResourceType]
    def policyDetails: Optional[
      List[zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly]
    ]
    def resourceSelection: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly
    ]
    def dateCreated: Optional[DateTimeTimestamp]
    def dateUpdated: Optional[DateTimeTimestamp]
    def dateLastRun: Optional[DateTimeTimestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, LifecyclePolicyArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getExecutionRole: ZIO[Any, AwsError, RoleNameOrArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getPolicyDetails: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("policyDetails", policyDetails)
    def getResourceSelection: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceSelection", resourceSelection)
    def getDateCreated: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getDateLastRun: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("dateLastRun", dateLastRun)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicy
  ) extends zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly {
    override val arn: Optional[LifecyclePolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val status
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.LifecyclePolicyStatus.wrap(value)
        )
    override val executionRole: Optional[RoleNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.imagebuilder.model.primitives.RoleNameOrArn(value))
    override val resourceType
        : Optional[zio.aws.imagebuilder.model.LifecyclePolicyResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.imagebuilder.model.LifecyclePolicyResourceType.wrap(value)
        )
    override val policyDetails: Optional[
      List[zio.aws.imagebuilder.model.LifecyclePolicyDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LifecyclePolicyDetail.wrap(item)
        }.toList
      )
    override val resourceSelection: Optional[
      zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceSelection())
      .map(value =>
        zio.aws.imagebuilder.model.LifecyclePolicyResourceSelection.wrap(value)
      )
    override val dateCreated: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateCreated())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val dateUpdated: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateUpdated())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val dateLastRun: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateLastRun())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecyclePolicy
  ): zio.aws.imagebuilder.model.LifecyclePolicy.ReadOnly = new Wrapper(impl)
}
