package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionState(
    status: Optional[zio.aws.imagebuilder.model.LifecycleExecutionStatus] =
      Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState = {
    import LifecycleExecutionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionState.wrap(buildAwsValue())
}
object LifecycleExecutionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecycleExecutionState =
      zio.aws.imagebuilder.model.LifecycleExecutionState(
        status.map(value => value),
        reason.map(value => value)
      )
    def status: Optional[zio.aws.imagebuilder.model.LifecycleExecutionStatus]
    def reason: Optional[NonEmptyString]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly {
    override val status
        : Optional[zio.aws.imagebuilder.model.LifecycleExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.LifecycleExecutionStatus.wrap(value)
        )
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState
  ): zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly = new Wrapper(
    impl
  )
}
