package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionSnapshotResource(
    snapshotId: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource = {
    import LifecycleExecutionSnapshotResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource
      .builder()
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource
      .wrap(buildAwsValue())
}
object LifecycleExecutionSnapshotResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource =
      zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource(
        snapshotId.map(value => value),
        state.map(value => value.asEditable)
      )
    def snapshotId: Optional[NonEmptyString]
    def state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ]
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly {
    override val snapshotId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourceState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourceState.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionSnapshotResource
  ): zio.aws.imagebuilder.model.LifecycleExecutionSnapshotResource.ReadOnly =
    new Wrapper(impl)
}
