package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleExecutionResourcesImpactedSummary(
    hasImpactedResources: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary = {
    import LifecycleExecutionResourcesImpactedSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
      .builder()
      .optionallyWith(
        hasImpactedResources.map(value => value: java.lang.Boolean)
      )(_.hasImpactedResources)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
      .wrap(buildAwsValue())
}
object LifecycleExecutionResourcesImpactedSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary =
      zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary(
        hasImpactedResources.map(value => value)
      )
    def hasImpactedResources: Optional[Boolean]
    def getHasImpactedResources: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasImpactedResources", hasImpactedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
  ) extends zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly {
    override val hasImpactedResources: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasImpactedResources())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
  ): zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly =
    new Wrapper(impl)
}
