package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  DateTimeTimestamp,
  LifecyclePolicyArn,
  LifecycleExecutionId
}
import scala.jdk.CollectionConverters.*
final case class LifecycleExecution(
    lifecycleExecutionId: Optional[LifecycleExecutionId] = Optional.Absent,
    lifecyclePolicyArn: Optional[LifecyclePolicyArn] = Optional.Absent,
    resourcesImpactedSummary: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
    ] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.LifecycleExecutionState] =
      Optional.Absent,
    startTime: Optional[DateTimeTimestamp] = Optional.Absent,
    endTime: Optional[DateTimeTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution = {
    import LifecycleExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution
      .builder()
      .optionallyWith(
        lifecycleExecutionId.map(value =>
          LifecycleExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleExecutionId)
      .optionallyWith(
        lifecyclePolicyArn.map(value =>
          LifecyclePolicyArn.unwrap(value): java.lang.String
        )
      )(_.lifecyclePolicyArn)
      .optionallyWith(
        resourcesImpactedSummary.map(value => value.buildAwsValue())
      )(_.resourcesImpactedSummary)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        startTime.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.endTime)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly =
    zio.aws.imagebuilder.model.LifecycleExecution.wrap(buildAwsValue())
}
object LifecycleExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LifecycleExecution =
      zio.aws.imagebuilder.model.LifecycleExecution(
        lifecycleExecutionId.map(value => value),
        lifecyclePolicyArn.map(value => value),
        resourcesImpactedSummary.map(value => value.asEditable),
        state.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def lifecycleExecutionId: Optional[LifecycleExecutionId]
    def lifecyclePolicyArn: Optional[LifecyclePolicyArn]
    def resourcesImpactedSummary: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly
    ]
    def state
        : Optional[zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly]
    def startTime: Optional[DateTimeTimestamp]
    def endTime: Optional[DateTimeTimestamp]
    def getLifecycleExecutionId: ZIO[Any, AwsError, LifecycleExecutionId] =
      AwsError.unwrapOptionField("lifecycleExecutionId", lifecycleExecutionId)
    def getLifecyclePolicyArn: ZIO[Any, AwsError, LifecyclePolicyArn] =
      AwsError.unwrapOptionField("lifecyclePolicyArn", lifecyclePolicyArn)
    def getResourcesImpactedSummary: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resourcesImpactedSummary",
      resourcesImpactedSummary
    )
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getStartTime: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution
  ) extends zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly {
    override val lifecycleExecutionId: Optional[LifecycleExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecycleExecutionId(value)
        )
    override val lifecyclePolicyArn: Optional[LifecyclePolicyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecyclePolicyArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.LifecyclePolicyArn(value)
        )
    override val resourcesImpactedSummary: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcesImpactedSummary())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary
          .wrap(value)
      )
    override val state: Optional[
      zio.aws.imagebuilder.model.LifecycleExecutionState.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.imagebuilder.model.LifecycleExecutionState.wrap(value)
      )
    override val startTime: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
    override val endTime: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LifecycleExecution
  ): zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly = new Wrapper(impl)
}
