package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{EmptyString, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InstanceBlockDeviceMapping(
    deviceName: Optional[NonEmptyString] = Optional.Absent,
    ebs: Optional[
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification
    ] = Optional.Absent,
    virtualName: Optional[NonEmptyString] = Optional.Absent,
    noDevice: Optional[EmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping = {
    import InstanceBlockDeviceMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping
      .builder()
      .optionallyWith(
        deviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(
        virtualName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.virtualName)
      .optionallyWith(
        noDevice.map(value => EmptyString.unwrap(value): java.lang.String)
      )(_.noDevice)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly =
    zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.wrap(buildAwsValue())
}
object InstanceBlockDeviceMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InstanceBlockDeviceMapping =
      zio.aws.imagebuilder.model.InstanceBlockDeviceMapping(
        deviceName.map(value => value),
        ebs.map(value => value.asEditable),
        virtualName.map(value => value),
        noDevice.map(value => value)
      )
    def deviceName: Optional[NonEmptyString]
    def ebs: Optional[
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly
    ]
    def virtualName: Optional[NonEmptyString]
    def noDevice: Optional[EmptyString]
    def getDeviceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getEbs: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("ebs", ebs)
    def getVirtualName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("virtualName", virtualName)
    def getNoDevice: ZIO[Any, AwsError, EmptyString] =
      AwsError.unwrapOptionField("noDevice", noDevice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping
  ) extends zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly {
    override val deviceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val ebs: Optional[
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ebs())
      .map(value =>
        zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification
          .wrap(value)
      )
    override val virtualName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualName())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val noDevice: Optional[EmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.noDevice())
      .map(value => zio.aws.imagebuilder.model.primitives.EmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceBlockDeviceMapping
  ): zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly =
    new Wrapper(impl)
}
