package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ClientToken, Arn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportVmImageResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageArn: Optional[Arn] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse = {
    import ImportVmImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly =
    zio.aws.imagebuilder.model.ImportVmImageResponse.wrap(buildAwsValue())
}
object ImportVmImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportVmImageResponse =
      zio.aws.imagebuilder.model.ImportVmImageResponse(
        requestId.map(value => value),
        imageArn.map(value => value),
        clientToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageArn: Optional[Arn]
    def clientToken: Optional[ClientToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ) extends zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.imageArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ): zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
