package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImageBuildVersionArn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportDiskImageResponse(
    clientToken: Optional[ClientToken] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse = {
    import ImportDiskImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly =
    zio.aws.imagebuilder.model.ImportDiskImageResponse.wrap(buildAwsValue())
}
object ImportDiskImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportDiskImageResponse =
      zio.aws.imagebuilder.model.ImportDiskImageResponse(
        clientToken.map(value => value),
        imageBuildVersionArn.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse
  ) extends zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportDiskImageResponse
  ): zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
