package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  Uri,
  VersionNumber,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportComponentRequest(
    name: ResourceName,
    semanticVersion: VersionNumber,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    `type`: zio.aws.imagebuilder.model.ComponentType,
    format: zio.aws.imagebuilder.model.ComponentFormat,
    platform: zio.aws.imagebuilder.model.Platform,
    data: Optional[NonEmptyString] = Optional.Absent,
    uri: Optional[Uri] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest = {
    import ImportComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .`type`(`type`.unwrap)
      .format(format.unwrap)
      .platform(platform.unwrap)
      .optionallyWith(
        data.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(uri.map(value => Uri.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportComponentRequest.ReadOnly =
    zio.aws.imagebuilder.model.ImportComponentRequest.wrap(buildAwsValue())
}
object ImportComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportComponentRequest =
      zio.aws.imagebuilder.model.ImportComponentRequest(
        name,
        semanticVersion,
        description.map(value => value),
        changeDescription.map(value => value),
        `type`,
        format,
        platform,
        data.map(value => value),
        uri.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value => value),
        clientToken
      )
    def name: ResourceName
    def semanticVersion: VersionNumber
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def `type`: zio.aws.imagebuilder.model.ComponentType
    def format: zio.aws.imagebuilder.model.ComponentFormat
    def platform: zio.aws.imagebuilder.model.Platform
    def data: Optional[NonEmptyString]
    def uri: Optional[Uri]
    def kmsKeyId: Optional[NonEmptyString]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getType: ZIO[Any, Nothing, zio.aws.imagebuilder.model.ComponentType] =
      ZIO.succeed(`type`)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.ComponentFormat] =
      ZIO.succeed(format)
    def getPlatform: ZIO[Any, Nothing, zio.aws.imagebuilder.model.Platform] =
      ZIO.succeed(platform)
    def getData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("data", data)
    def getUri: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("uri", uri)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest
  ) extends zio.aws.imagebuilder.model.ImportComponentRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val `type`: zio.aws.imagebuilder.model.ComponentType =
      zio.aws.imagebuilder.model.ComponentType.wrap(impl.`type`())
    override val format: zio.aws.imagebuilder.model.ComponentFormat =
      zio.aws.imagebuilder.model.ComponentFormat.wrap(impl.format())
    override val platform: zio.aws.imagebuilder.model.Platform =
      zio.aws.imagebuilder.model.Platform.wrap(impl.platform())
    override val data: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.imagebuilder.model.primitives.Uri(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest
  ): zio.aws.imagebuilder.model.ImportComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
