package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  ImageTestsTimeoutMinutes,
  NullableBoolean
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ImageTestsConfiguration(
    imageTestsEnabled: Optional[NullableBoolean] = Optional.Absent,
    timeoutMinutes: Optional[ImageTestsTimeoutMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration = {
    import ImageTestsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration
      .builder()
      .optionallyWith(imageTestsEnabled.map(value => value: java.lang.Boolean))(
        _.imageTestsEnabled
      )
      .optionallyWith(
        timeoutMinutes.map(value =>
          ImageTestsTimeoutMinutes.unwrap(value): Integer
        )
      )(_.timeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(buildAwsValue())
}
object ImageTestsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageTestsConfiguration =
      zio.aws.imagebuilder.model.ImageTestsConfiguration(
        imageTestsEnabled.map(value => value),
        timeoutMinutes.map(value => value)
      )
    def imageTestsEnabled: Optional[NullableBoolean]
    def timeoutMinutes: Optional[ImageTestsTimeoutMinutes]
    def getImageTestsEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("imageTestsEnabled", imageTestsEnabled)
    def getTimeoutMinutes: ZIO[Any, AwsError, ImageTestsTimeoutMinutes] =
      AwsError.unwrapOptionField("timeoutMinutes", timeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration
  ) extends zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly {
    override val imageTestsEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageTestsEnabled())
        .map(value => value: NullableBoolean)
    override val timeoutMinutes: Optional[ImageTestsTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutMinutes())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageTestsTimeoutMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration
  ): zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
