package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ImageSource {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ImageSource
}
object ImageSource {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ImageSource
  ): zio.aws.imagebuilder.model.ImageSource = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ImageSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageSource.AMAZON_MANAGED =>
      val r = AMAZON_MANAGED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageSource.AWS_MARKETPLACE =>
      val r = AWS_MARKETPLACE
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageSource.IMPORTED =>
      val r = IMPORTED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageSource.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ImageSource {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageSource =
      software.amazon.awssdk.services.imagebuilder.model.ImageSource.UNKNOWN_TO_SDK_VERSION
  }
  case object AMAZON_MANAGED extends zio.aws.imagebuilder.model.ImageSource {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageSource =
      software.amazon.awssdk.services.imagebuilder.model.ImageSource.AMAZON_MANAGED
  }
  case object AWS_MARKETPLACE extends zio.aws.imagebuilder.model.ImageSource {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageSource =
      software.amazon.awssdk.services.imagebuilder.model.ImageSource.AWS_MARKETPLACE
  }
  case object IMPORTED extends zio.aws.imagebuilder.model.ImageSource {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageSource =
      software.amazon.awssdk.services.imagebuilder.model.ImageSource.IMPORTED
  }
  case object CUSTOM extends zio.aws.imagebuilder.model.ImageSource {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageSource =
      software.amazon.awssdk.services.imagebuilder.model.ImageSource.CUSTOM
  }
}
