package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NullableBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImageScanningConfiguration(
    imageScanningEnabled: Optional[NullableBoolean] = Optional.Absent,
    ecrConfiguration: Optional[zio.aws.imagebuilder.model.EcrConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration = {
    import ImageScanningConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration
      .builder()
      .optionallyWith(
        imageScanningEnabled.map(value => value: java.lang.Boolean)
      )(_.imageScanningEnabled)
      .optionallyWith(ecrConfiguration.map(value => value.buildAwsValue()))(
        _.ecrConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.ImageScanningConfiguration.wrap(buildAwsValue())
}
object ImageScanningConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageScanningConfiguration =
      zio.aws.imagebuilder.model.ImageScanningConfiguration(
        imageScanningEnabled.map(value => value),
        ecrConfiguration.map(value => value.asEditable)
      )
    def imageScanningEnabled: Optional[NullableBoolean]
    def ecrConfiguration
        : Optional[zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly]
    def getImageScanningEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("imageScanningEnabled", imageScanningEnabled)
    def getEcrConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ecrConfiguration", ecrConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration
  ) extends zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly {
    override val imageScanningEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageScanningEnabled())
        .map(value => value: NullableBoolean)
    override val ecrConfiguration
        : Optional[zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecrConfiguration())
        .map(value => zio.aws.imagebuilder.model.EcrConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration
  ): zio.aws.imagebuilder.model.ImageScanningConfiguration.ReadOnly =
    new Wrapper(impl)
}
