package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImageScanFindingAggregation(
    accountAggregation: Optional[
      zio.aws.imagebuilder.model.AccountAggregation
    ] = Optional.Absent,
    imageAggregation: Optional[zio.aws.imagebuilder.model.ImageAggregation] =
      Optional.Absent,
    imagePipelineAggregation: Optional[
      zio.aws.imagebuilder.model.ImagePipelineAggregation
    ] = Optional.Absent,
    vulnerabilityIdAggregation: Optional[
      zio.aws.imagebuilder.model.VulnerabilityIdAggregation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation = {
    import ImageScanFindingAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation
      .builder()
      .optionallyWith(accountAggregation.map(value => value.buildAwsValue()))(
        _.accountAggregation
      )
      .optionallyWith(imageAggregation.map(value => value.buildAwsValue()))(
        _.imageAggregation
      )
      .optionallyWith(
        imagePipelineAggregation.map(value => value.buildAwsValue())
      )(_.imagePipelineAggregation)
      .optionallyWith(
        vulnerabilityIdAggregation.map(value => value.buildAwsValue())
      )(_.vulnerabilityIdAggregation)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly =
    zio.aws.imagebuilder.model.ImageScanFindingAggregation.wrap(buildAwsValue())
}
object ImageScanFindingAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageScanFindingAggregation =
      zio.aws.imagebuilder.model.ImageScanFindingAggregation(
        accountAggregation.map(value => value.asEditable),
        imageAggregation.map(value => value.asEditable),
        imagePipelineAggregation.map(value => value.asEditable),
        vulnerabilityIdAggregation.map(value => value.asEditable)
      )
    def accountAggregation
        : Optional[zio.aws.imagebuilder.model.AccountAggregation.ReadOnly]
    def imageAggregation
        : Optional[zio.aws.imagebuilder.model.ImageAggregation.ReadOnly]
    def imagePipelineAggregation
        : Optional[zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly]
    def vulnerabilityIdAggregation: Optional[
      zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly
    ]
    def getAccountAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.AccountAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("accountAggregation", accountAggregation)
    def getImageAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageAggregation.ReadOnly
    ] = AwsError.unwrapOptionField("imageAggregation", imageAggregation)
    def getImagePipelineAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imagePipelineAggregation",
      imagePipelineAggregation
    )
    def getVulnerabilityIdAggregation: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vulnerabilityIdAggregation",
      vulnerabilityIdAggregation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation
  ) extends zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly {
    override val accountAggregation
        : Optional[zio.aws.imagebuilder.model.AccountAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountAggregation())
        .map(value => zio.aws.imagebuilder.model.AccountAggregation.wrap(value))
    override val imageAggregation
        : Optional[zio.aws.imagebuilder.model.ImageAggregation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageAggregation())
        .map(value => zio.aws.imagebuilder.model.ImageAggregation.wrap(value))
    override val imagePipelineAggregation: Optional[
      zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imagePipelineAggregation())
      .map(value =>
        zio.aws.imagebuilder.model.ImagePipelineAggregation.wrap(value)
      )
    override val vulnerabilityIdAggregation: Optional[
      zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vulnerabilityIdAggregation())
      .map(value =>
        zio.aws.imagebuilder.model.VulnerabilityIdAggregation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation
  ): zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly =
    new Wrapper(impl)
}
