package zio.aws.imagebuilder.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  ImagePipelineArn,
  ImageBuildVersionArn,
  NonNegativeDouble,
  DateTimeTimestamp,
  NonEmptyString
}
import scala.jdk.CollectionConverters.*
final case class ImageScanFinding(
    awsAccountId: Optional[NonEmptyString] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    imagePipelineArn: Optional[ImagePipelineArn] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    title: Optional[NonEmptyString] = Optional.Absent,
    remediation: Optional[zio.aws.imagebuilder.model.Remediation] =
      Optional.Absent,
    severity: Optional[NonEmptyString] = Optional.Absent,
    firstObservedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    updatedAt: Optional[DateTimeTimestamp] = Optional.Absent,
    inspectorScore: Optional[NonNegativeDouble] = Optional.Absent,
    inspectorScoreDetails: Optional[
      zio.aws.imagebuilder.model.InspectorScoreDetails
    ] = Optional.Absent,
    packageVulnerabilityDetails: Optional[
      zio.aws.imagebuilder.model.PackageVulnerabilityDetails
    ] = Optional.Absent,
    fixAvailable: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding = {
    import ImageScanFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding
      .builder()
      .optionallyWith(
        awsAccountId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.awsAccountId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        title.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(remediation.map(value => value.buildAwsValue()))(
        _.remediation
      )
      .optionallyWith(
        severity.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        firstObservedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.firstObservedAt)
      .optionallyWith(
        updatedAt.map(value => DateTimeTimestamp.unwrap(value): Instant)
      )(_.updatedAt)
      .optionallyWith(
        inspectorScore.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.inspectorScore)
      .optionallyWith(
        inspectorScoreDetails.map(value => value.buildAwsValue())
      )(_.inspectorScoreDetails)
      .optionallyWith(
        packageVulnerabilityDetails.map(value => value.buildAwsValue())
      )(_.packageVulnerabilityDetails)
      .optionallyWith(
        fixAvailable.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fixAvailable)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly =
    zio.aws.imagebuilder.model.ImageScanFinding.wrap(buildAwsValue())
}
object ImageScanFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageScanFinding =
      zio.aws.imagebuilder.model.ImageScanFinding(
        awsAccountId.map(value => value),
        imageBuildVersionArn.map(value => value),
        imagePipelineArn.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        title.map(value => value),
        remediation.map(value => value.asEditable),
        severity.map(value => value),
        firstObservedAt.map(value => value),
        updatedAt.map(value => value),
        inspectorScore.map(value => value),
        inspectorScoreDetails.map(value => value.asEditable),
        packageVulnerabilityDetails.map(value => value.asEditable),
        fixAvailable.map(value => value)
      )
    def awsAccountId: Optional[NonEmptyString]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def imagePipelineArn: Optional[ImagePipelineArn]
    def `type`: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def title: Optional[NonEmptyString]
    def remediation: Optional[zio.aws.imagebuilder.model.Remediation.ReadOnly]
    def severity: Optional[NonEmptyString]
    def firstObservedAt: Optional[DateTimeTimestamp]
    def updatedAt: Optional[DateTimeTimestamp]
    def inspectorScore: Optional[NonNegativeDouble]
    def inspectorScoreDetails
        : Optional[zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly]
    def packageVulnerabilityDetails: Optional[
      zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly
    ]
    def fixAvailable: Optional[NonEmptyString]
    def getAwsAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getTitle: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("title", title)
    def getRemediation
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Remediation.ReadOnly] =
      AwsError.unwrapOptionField("remediation", remediation)
    def getSeverity: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("severity", severity)
    def getFirstObservedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getUpdatedAt: ZIO[Any, AwsError, DateTimeTimestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getInspectorScore: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("inspectorScore", inspectorScore)
    def getInspectorScoreDetails: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("inspectorScoreDetails", inspectorScoreDetails)
    def getPackageVulnerabilityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "packageVulnerabilityDetails",
      packageVulnerabilityDetails
    )
    def getFixAvailable: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fixAvailable", fixAvailable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding
  ) extends zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly {
    override val awsAccountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val imagePipelineArn: Optional[ImagePipelineArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePipelineArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
        )
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val title: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val remediation
        : Optional[zio.aws.imagebuilder.model.Remediation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediation())
        .map(value => zio.aws.imagebuilder.model.Remediation.wrap(value))
    override val severity: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val firstObservedAt: Optional[DateTimeTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstObservedAt())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
        )
    override val updatedAt: Optional[DateTimeTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DateTimeTimestamp(value)
      )
    override val inspectorScore: Optional[NonNegativeDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inspectorScore())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonNegativeDouble(value)
        )
    override val inspectorScoreDetails
        : Optional[zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inspectorScoreDetails())
        .map(value =>
          zio.aws.imagebuilder.model.InspectorScoreDetails.wrap(value)
        )
    override val packageVulnerabilityDetails: Optional[
      zio.aws.imagebuilder.model.PackageVulnerabilityDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.packageVulnerabilityDetails())
      .map(value =>
        zio.aws.imagebuilder.model.PackageVulnerabilityDetails.wrap(value)
      )
    override val fixAvailable: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.fixAvailable())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding
  ): zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly = new Wrapper(impl)
}
