package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImageRecipe(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ImageType] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    components: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentConfiguration]
    ] = Optional.Absent,
    parentImage: Optional[NonEmptyString] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
    ] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workingDirectory: Optional[NonEmptyString] = Optional.Absent,
    additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageRecipe = {
    import ImageRecipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        parentImage.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.parentImage)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(
        additionalInstanceConfiguration.map(value => value.buildAwsValue())
      )(_.additionalInstanceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageRecipe.ReadOnly =
    zio.aws.imagebuilder.model.ImageRecipe.wrap(buildAwsValue())
}
object ImageRecipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageRecipe =
      zio.aws.imagebuilder.model.ImageRecipe(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        owner.map(value => value),
        version.map(value => value),
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parentImage.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dateCreated.map(value => value),
        tags.map(value => value),
        workingDirectory.map(value => value),
        additionalInstanceConfiguration.map(value => value.asEditable)
      )
    def arn: Optional[ImageBuilderArn]
    def `type`: Optional[zio.aws.imagebuilder.model.ImageType]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def owner: Optional[NonEmptyString]
    def version: Optional[VersionNumber]
    def components: Optional[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ]
    def parentImage: Optional[NonEmptyString]
    def blockDeviceMappings: Optional[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def workingDirectory: Optional[NonEmptyString]
    def additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getParentImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentImage", parentImage)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getAdditionalInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "additionalInstanceConfiguration",
      additionalInstanceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ) extends zio.aws.imagebuilder.model.ImageRecipe.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val `type`: Optional[zio.aws.imagebuilder.model.ImageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val components: Optional[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }.toList
      )
    override val parentImage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.parentImage())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val blockDeviceMappings: Optional[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInstanceConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ): zio.aws.imagebuilder.model.ImageRecipe.ReadOnly = new Wrapper(impl)
}
