package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImagePackage(
    packageName: Optional[NonEmptyString] = Optional.Absent,
    packageVersion: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImagePackage = {
    import ImagePackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImagePackage
      .builder()
      .optionallyWith(
        packageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(
        packageVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImagePackage.ReadOnly =
    zio.aws.imagebuilder.model.ImagePackage.wrap(buildAwsValue())
}
object ImagePackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImagePackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImagePackage =
      zio.aws.imagebuilder.model.ImagePackage(
        packageName.map(value => value),
        packageVersion.map(value => value)
      )
    def packageName: Optional[NonEmptyString]
    def packageVersion: Optional[NonEmptyString]
    def getPackageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackageVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePackage
  ) extends zio.aws.imagebuilder.model.ImagePackage.ReadOnly {
    override val packageName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val packageVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePackage
  ): zio.aws.imagebuilder.model.ImagePackage.ReadOnly = new Wrapper(impl)
}
