package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetWorkflowResponse(
    workflow: Optional[zio.aws.imagebuilder.model.Workflow] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse = {
    import GetWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse
      .builder()
      .optionallyWith(workflow.map(value => value.buildAwsValue()))(_.workflow)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetWorkflowResponse.wrap(buildAwsValue())
}
object GetWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetWorkflowResponse =
      zio.aws.imagebuilder.model
        .GetWorkflowResponse(workflow.map(value => value.asEditable))
    def workflow: Optional[zio.aws.imagebuilder.model.Workflow.ReadOnly]
    def getWorkflow
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Workflow.ReadOnly] =
      AwsError.unwrapOptionField("workflow", workflow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse
  ) extends zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly {
    override val workflow
        : Optional[zio.aws.imagebuilder.model.Workflow.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflow())
        .map(value => zio.aws.imagebuilder.model.Workflow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowResponse
  ): zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly = new Wrapper(impl)
}
