package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDistributionConfigurationResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse = {
    import GetDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfiguration.map(value => value.buildAwsValue())
      )(_.distributionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object GetDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.GetDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.GetDistributionConfigurationResponse(
        requestId.map(value => value),
        distributionConfiguration.map(value => value.asEditable)
      )
    def requestId: Optional[NonEmptyString]
    def distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "distributionConfiguration",
      distributionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfiguration: Optional[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.DistributionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
