package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetContainerRecipeResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    containerRecipe: Optional[zio.aws.imagebuilder.model.ContainerRecipe] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse = {
    import GetContainerRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(containerRecipe.map(value => value.buildAwsValue()))(
        _.containerRecipe
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.wrap(buildAwsValue())
}
object GetContainerRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetContainerRecipeResponse =
      zio.aws.imagebuilder.model.GetContainerRecipeResponse(
        requestId.map(value => value),
        containerRecipe.map(value => value.asEditable)
      )
    def requestId: Optional[NonEmptyString]
    def containerRecipe
        : Optional[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipe: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly
    ] = AwsError.unwrapOptionField("containerRecipe", containerRecipe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ) extends zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipe
        : Optional[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerRecipe())
        .map(value => zio.aws.imagebuilder.model.ContainerRecipe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ): zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
