package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetComponentPolicyRequest(
    componentArn: ComponentBuildVersionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest = {
    import GetComponentPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest
      .builder()
      .componentArn(
        ComponentBuildVersionArn.unwrap(componentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetComponentPolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.GetComponentPolicyRequest.wrap(buildAwsValue())
}
object GetComponentPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetComponentPolicyRequest =
      zio.aws.imagebuilder.model.GetComponentPolicyRequest(componentArn)
    def componentArn: ComponentBuildVersionArn
    def getComponentArn: ZIO[Any, Nothing, ComponentBuildVersionArn] =
      ZIO.succeed(componentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest
  ) extends zio.aws.imagebuilder.model.GetComponentPolicyRequest.ReadOnly {
    override val componentArn: ComponentBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentBuildVersionArn(impl.componentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest
  ): zio.aws.imagebuilder.model.GetComponentPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
