package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EcrConfiguration(
    repositoryName: Optional[NonEmptyString] = Optional.Absent,
    containerTags: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration = {
    import EcrConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        containerTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerTags)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.EcrConfiguration.wrap(buildAwsValue())
}
object EcrConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.EcrConfiguration =
      zio.aws.imagebuilder.model.EcrConfiguration(
        repositoryName.map(value => value),
        containerTags.map(value => value)
      )
    def repositoryName: Optional[NonEmptyString]
    def containerTags: Optional[List[NonEmptyString]]
    def getRepositoryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getContainerTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("containerTags", containerTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration
  ) extends zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly {
    override val repositoryName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val containerTags: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.EcrConfiguration
  ): zio.aws.imagebuilder.model.EcrConfiguration.ReadOnly = new Wrapper(impl)
}
