package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  LicenseConfigurationArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Distribution(
    region: NonEmptyString,
    amiDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.AmiDistributionConfiguration
    ] = Optional.Absent,
    containerDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.ContainerDistributionConfiguration
    ] = Optional.Absent,
    licenseConfigurationArns: Optional[Iterable[LicenseConfigurationArn]] =
      Optional.Absent,
    launchTemplateConfigurations: Optional[
      Iterable[zio.aws.imagebuilder.model.LaunchTemplateConfiguration]
    ] = Optional.Absent,
    s3ExportConfiguration: Optional[
      zio.aws.imagebuilder.model.S3ExportConfiguration
    ] = Optional.Absent,
    fastLaunchConfigurations: Optional[
      Iterable[zio.aws.imagebuilder.model.FastLaunchConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Distribution = {
    import Distribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Distribution
      .builder()
      .region(NonEmptyString.unwrap(region): java.lang.String)
      .optionallyWith(
        amiDistributionConfiguration.map(value => value.buildAwsValue())
      )(_.amiDistributionConfiguration)
      .optionallyWith(
        containerDistributionConfiguration.map(value => value.buildAwsValue())
      )(_.containerDistributionConfiguration)
      .optionallyWith(
        licenseConfigurationArns.map(value =>
          value.map { item =>
            LicenseConfigurationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.licenseConfigurationArns)
      .optionallyWith(
        launchTemplateConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigurations)
      .optionallyWith(
        s3ExportConfiguration.map(value => value.buildAwsValue())
      )(_.s3ExportConfiguration)
      .optionallyWith(
        fastLaunchConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastLaunchConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Distribution.ReadOnly =
    zio.aws.imagebuilder.model.Distribution.wrap(buildAwsValue())
}
object Distribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Distribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Distribution =
      zio.aws.imagebuilder.model.Distribution(
        region,
        amiDistributionConfiguration.map(value => value.asEditable),
        containerDistributionConfiguration.map(value => value.asEditable),
        licenseConfigurationArns.map(value => value),
        launchTemplateConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3ExportConfiguration.map(value => value.asEditable),
        fastLaunchConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def region: NonEmptyString
    def amiDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly
    ]
    def containerDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly
    ]
    def licenseConfigurationArns: Optional[List[LicenseConfigurationArn]]
    def launchTemplateConfigurations: Optional[
      List[zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly]
    ]
    def s3ExportConfiguration
        : Optional[zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly]
    def fastLaunchConfigurations: Optional[
      List[zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly]
    ]
    def getRegion: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(region)
    def getAmiDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "amiDistributionConfiguration",
      amiDistributionConfiguration
    )
    def getContainerDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "containerDistributionConfiguration",
      containerDistributionConfiguration
    )
    def getLicenseConfigurationArns
        : ZIO[Any, AwsError, List[LicenseConfigurationArn]] = AwsError
      .unwrapOptionField("licenseConfigurationArns", licenseConfigurationArns)
    def getLaunchTemplateConfigurations: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "launchTemplateConfigurations",
      launchTemplateConfigurations
    )
    def getS3ExportConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("s3ExportConfiguration", s3ExportConfiguration)
    def getFastLaunchConfigurations: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fastLaunchConfigurations",
      fastLaunchConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Distribution
  ) extends zio.aws.imagebuilder.model.Distribution.ReadOnly {
    override val region: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.region())
    override val amiDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.amiDistributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.AmiDistributionConfiguration.wrap(value)
      )
    override val containerDistributionConfiguration: Optional[
      zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containerDistributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.ContainerDistributionConfiguration
          .wrap(value)
      )
    override val licenseConfigurationArns
        : Optional[List[LicenseConfigurationArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseConfigurationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.LicenseConfigurationArn(item)
        }.toList
      )
    override val launchTemplateConfigurations: Optional[
      List[zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.LaunchTemplateConfiguration.wrap(item)
        }.toList
      )
    override val s3ExportConfiguration
        : Optional[zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ExportConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.S3ExportConfiguration.wrap(value)
        )
    override val fastLaunchConfigurations: Optional[
      List[zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fastLaunchConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.FastLaunchConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Distribution
  ): zio.aws.imagebuilder.model.Distribution.ReadOnly = new Wrapper(impl)
}
