package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImageRecipeArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteImageRecipeResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageRecipeArn: Optional[ImageRecipeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse = {
    import DeleteImageRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteImageRecipeResponse.wrap(buildAwsValue())
}
object DeleteImageRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteImageRecipeResponse =
      zio.aws.imagebuilder.model.DeleteImageRecipeResponse(
        requestId.map(value => value),
        imageRecipeArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageRecipeArn: Optional[ImageRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ) extends zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Optional[ImageRecipeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageRecipeArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ): zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
