package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImagePipelineArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteImagePipelineResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imagePipelineArn: Optional[ImagePipelineArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse = {
    import DeleteImagePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.wrap(buildAwsValue())
}
object DeleteImagePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteImagePipelineResponse =
      zio.aws.imagebuilder.model.DeleteImagePipelineResponse(
        requestId.map(value => value),
        imagePipelineArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imagePipelineArn: Optional[ImagePipelineArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ) extends zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imagePipelineArn: Optional[ImagePipelineArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePipelineArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ): zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
