package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDistributionConfigurationResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    distributionConfigurationArn: Optional[DistributionConfigurationArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse = {
    import DeleteDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object DeleteDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse(
        requestId.map(value => value),
        distributionConfigurationArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def distributionConfigurationArn: Optional[DistributionConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfigurationArn
        : Optional[DistributionConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
