package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentBuildVersionArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteComponentResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    componentBuildVersionArn: Optional[ComponentBuildVersionArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse = {
    import DeleteComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        componentBuildVersionArn.map(value =>
          ComponentBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.componentBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteComponentResponse.wrap(buildAwsValue())
}
object DeleteComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteComponentResponse =
      zio.aws.imagebuilder.model.DeleteComponentResponse(
        requestId.map(value => value),
        componentBuildVersionArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def componentBuildVersionArn: Optional[ComponentBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponentBuildVersionArn
        : ZIO[Any, AwsError, ComponentBuildVersionArn] = AwsError
      .unwrapOptionField("componentBuildVersionArn", componentBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ) extends zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val componentBuildVersionArn: Optional[ComponentBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ): zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
