package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{NonNegativeDouble, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CvssScoreDetails(
    scoreSource: Optional[NonEmptyString] = Optional.Absent,
    cvssSource: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    score: Optional[NonNegativeDouble] = Optional.Absent,
    scoringVector: Optional[NonEmptyString] = Optional.Absent,
    adjustments: Optional[
      Iterable[zio.aws.imagebuilder.model.CvssScoreAdjustment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CvssScoreDetails = {
    import CvssScoreDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CvssScoreDetails
      .builder()
      .optionallyWith(
        scoreSource.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scoreSource)
      .optionallyWith(
        cvssSource.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cvssSource)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        score.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.score)
      .optionallyWith(
        scoringVector.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.scoringVector)
      .optionallyWith(
        adjustments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adjustments)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly =
    zio.aws.imagebuilder.model.CvssScoreDetails.wrap(buildAwsValue())
}
object CvssScoreDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CvssScoreDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CvssScoreDetails =
      zio.aws.imagebuilder.model.CvssScoreDetails(
        scoreSource.map(value => value),
        cvssSource.map(value => value),
        version.map(value => value),
        score.map(value => value),
        scoringVector.map(value => value),
        adjustments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scoreSource: Optional[NonEmptyString]
    def cvssSource: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def score: Optional[NonNegativeDouble]
    def scoringVector: Optional[NonEmptyString]
    def adjustments: Optional[
      List[zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly]
    ]
    def getScoreSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scoreSource", scoreSource)
    def getCvssSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cvssSource", cvssSource)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getScore: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("score", score)
    def getScoringVector: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scoringVector", scoringVector)
    def getAdjustments: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly
    ]] = AwsError.unwrapOptionField("adjustments", adjustments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScoreDetails
  ) extends zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly {
    override val scoreSource: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scoreSource())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val cvssSource: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.cvssSource())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val score: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NonNegativeDouble(value)
      )
    override val scoringVector: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringVector())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val adjustments: Optional[
      List[zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adjustments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.CvssScoreAdjustment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScoreDetails
  ): zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly = new Wrapper(impl)
}
