package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CvssScoreAdjustment(
    metric: Optional[NonEmptyString] = Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CvssScoreAdjustment = {
    import CvssScoreAdjustment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CvssScoreAdjustment
      .builder()
      .optionallyWith(
        metric.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metric)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly =
    zio.aws.imagebuilder.model.CvssScoreAdjustment.wrap(buildAwsValue())
}
object CvssScoreAdjustment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CvssScoreAdjustment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CvssScoreAdjustment =
      zio.aws.imagebuilder.model.CvssScoreAdjustment(
        metric.map(value => value),
        reason.map(value => value)
      )
    def metric: Optional[NonEmptyString]
    def reason: Optional[NonEmptyString]
    def getMetric: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metric", metric)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScoreAdjustment
  ) extends zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly {
    override val metric: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metric())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScoreAdjustment
  ): zio.aws.imagebuilder.model.CvssScoreAdjustment.ReadOnly = new Wrapper(impl)
}
