package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  WorkflowBuildVersionArn,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowResponse(
    clientToken: Optional[ClientToken] = Optional.Absent,
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse = {
    import CreateWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateWorkflowResponse.wrap(buildAwsValue())
}
object CreateWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateWorkflowResponse =
      zio.aws.imagebuilder.model.CreateWorkflowResponse(
        clientToken.map(value => value),
        workflowBuildVersionArn.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse
  ) extends zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateWorkflowResponse
  ): zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly = new Wrapper(
    impl
  )
}
