package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  Uri,
  InlineDockerFileTemplate,
  VersionNumber,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateContainerRecipeRequest(
    containerType: zio.aws.imagebuilder.model.ContainerType,
    name: ResourceName,
    description: Optional[NonEmptyString] = Optional.Absent,
    semanticVersion: VersionNumber,
    components: Iterable[zio.aws.imagebuilder.model.ComponentConfiguration],
    instanceConfiguration: Optional[
      zio.aws.imagebuilder.model.InstanceConfiguration
    ] = Optional.Absent,
    dockerfileTemplateData: Optional[InlineDockerFileTemplate] =
      Optional.Absent,
    dockerfileTemplateUri: Optional[Uri] = Optional.Absent,
    platformOverride: Optional[zio.aws.imagebuilder.model.Platform] =
      Optional.Absent,
    imageOsVersionOverride: Optional[NonEmptyString] = Optional.Absent,
    parentImage: NonEmptyString,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workingDirectory: Optional[NonEmptyString] = Optional.Absent,
    targetRepository: zio.aws.imagebuilder.model.TargetContainerRepository,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest = {
    import CreateContainerRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
      .builder()
      .containerType(containerType.unwrap)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .components(components.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        dockerfileTemplateData.map(value =>
          InlineDockerFileTemplate.unwrap(value): java.lang.String
        )
      )(_.dockerfileTemplateData)
      .optionallyWith(
        dockerfileTemplateUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.dockerfileTemplateUri)
      .optionallyWith(platformOverride.map(value => value.unwrap))(
        _.platformOverride
      )
      .optionallyWith(
        imageOsVersionOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imageOsVersionOverride)
      .parentImage(NonEmptyString.unwrap(parentImage): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .targetRepository(targetRepository.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateContainerRecipeRequest
      .wrap(buildAwsValue())
}
object CreateContainerRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateContainerRecipeRequest =
      zio.aws.imagebuilder.model.CreateContainerRecipeRequest(
        containerType,
        name,
        description.map(value => value),
        semanticVersion,
        components.map { item =>
          item.asEditable
        },
        instanceConfiguration.map(value => value.asEditable),
        dockerfileTemplateData.map(value => value),
        dockerfileTemplateUri.map(value => value),
        platformOverride.map(value => value),
        imageOsVersionOverride.map(value => value),
        parentImage,
        tags.map(value => value),
        workingDirectory.map(value => value),
        targetRepository.asEditable,
        kmsKeyId.map(value => value),
        clientToken
      )
    def containerType: zio.aws.imagebuilder.model.ContainerType
    def name: ResourceName
    def description: Optional[NonEmptyString]
    def semanticVersion: VersionNumber
    def components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    def instanceConfiguration
        : Optional[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly]
    def dockerfileTemplateData: Optional[InlineDockerFileTemplate]
    def dockerfileTemplateUri: Optional[Uri]
    def platformOverride: Optional[zio.aws.imagebuilder.model.Platform]
    def imageOsVersionOverride: Optional[NonEmptyString]
    def parentImage: NonEmptyString
    def tags: Optional[Map[TagKey, TagValue]]
    def workingDirectory: Optional[NonEmptyString]
    def targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    def kmsKeyId: Optional[NonEmptyString]
    def clientToken: ClientToken
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.ContainerType] =
      ZIO.succeed(containerType)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getComponents: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = ZIO.succeed(components)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getDockerfileTemplateData
        : ZIO[Any, AwsError, InlineDockerFileTemplate] = AwsError
      .unwrapOptionField("dockerfileTemplateData", dockerfileTemplateData)
    def getDockerfileTemplateUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("dockerfileTemplateUri", dockerfileTemplateUri)
    def getPlatformOverride
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platformOverride", platformOverride)
    def getImageOsVersionOverride: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("imageOsVersionOverride", imageOsVersionOverride)
    def getParentImage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(parentImage)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getTargetRepository: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = ZIO.succeed(targetRepository)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ) extends zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly {
    override val containerType: zio.aws.imagebuilder.model.ContainerType =
      zio.aws.imagebuilder.model.ContainerType.wrap(impl.containerType())
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly] =
      impl
        .components()
        .asScala
        .map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }
        .toList
    override val instanceConfiguration
        : Optional[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceConfiguration.wrap(value)
        )
    override val dockerfileTemplateData: Optional[InlineDockerFileTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerfileTemplateData())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.InlineDockerFileTemplate(value)
        )
    override val dockerfileTemplateUri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.dockerfileTemplateUri())
      .map(value => zio.aws.imagebuilder.model.primitives.Uri(value))
    override val platformOverride
        : Optional[zio.aws.imagebuilder.model.Platform] = zio.aws.core.internal
      .optionalFromNullable(impl.platformOverride())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val imageOsVersionOverride: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageOsVersionOverride())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val parentImage: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.parentImage())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly =
      zio.aws.imagebuilder.model.TargetContainerRepository
        .wrap(impl.targetRepository())
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ): zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly =
    new Wrapper(impl)
}
