package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InlineComponentData,
  TagValue,
  Uri,
  VersionNumber,
  ClientToken,
  OsVersion,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateComponentRequest(
    name: ResourceName,
    semanticVersion: VersionNumber,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    platform: zio.aws.imagebuilder.model.Platform,
    supportedOsVersions: Optional[Iterable[OsVersion]] = Optional.Absent,
    data: Optional[InlineComponentData] = Optional.Absent,
    uri: Optional[Uri] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest = {
    import CreateComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .platform(platform.unwrap)
      .optionallyWith(
        supportedOsVersions.map(value =>
          value.map { item =>
            OsVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedOsVersions)
      .optionallyWith(
        data.map(value => InlineComponentData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(uri.map(value => Uri.unwrap(value): java.lang.String))(
        _.uri
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateComponentRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateComponentRequest.wrap(buildAwsValue())
}
object CreateComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateComponentRequest =
      zio.aws.imagebuilder.model.CreateComponentRequest(
        name,
        semanticVersion,
        description.map(value => value),
        changeDescription.map(value => value),
        platform,
        supportedOsVersions.map(value => value),
        data.map(value => value),
        uri.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value => value),
        clientToken
      )
    def name: ResourceName
    def semanticVersion: VersionNumber
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def platform: zio.aws.imagebuilder.model.Platform
    def supportedOsVersions: Optional[List[OsVersion]]
    def data: Optional[InlineComponentData]
    def uri: Optional[Uri]
    def kmsKeyId: Optional[NonEmptyString]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getPlatform: ZIO[Any, Nothing, zio.aws.imagebuilder.model.Platform] =
      ZIO.succeed(platform)
    def getSupportedOsVersions: ZIO[Any, AwsError, List[OsVersion]] =
      AwsError.unwrapOptionField("supportedOsVersions", supportedOsVersions)
    def getData: ZIO[Any, AwsError, InlineComponentData] =
      AwsError.unwrapOptionField("data", data)
    def getUri: ZIO[Any, AwsError, Uri] = AwsError.unwrapOptionField("uri", uri)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest
  ) extends zio.aws.imagebuilder.model.CreateComponentRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val platform: zio.aws.imagebuilder.model.Platform =
      zio.aws.imagebuilder.model.Platform.wrap(impl.platform())
    override val supportedOsVersions: Optional[List[OsVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOsVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OsVersion(item)
          }.toList
        )
    override val data: Optional[InlineComponentData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.InlineComponentData(value)
      )
    override val uri: Optional[Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.imagebuilder.model.primitives.Uri(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest
  ): zio.aws.imagebuilder.model.CreateComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
